# ADOxx Changelog excerpt

All notable changes to the **ADOxx Platform** project are documented here.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Changelog categories: Added, Changed, Deprecated, Removed, Fixed, Security



## [1.8.0] - 2023-09-22

### Added
* Support for SQLite as a lightweight DBMS. This does not require the
  additional installation of a DBMS server and provides a simpler alternative
  to MS SQL Server. By default the databases are simple files in
  `%APPDATA%/ADOxx/sqlitedbs/`. Some notes:
    - The environment variable `ADO_SQLITE_DBFOLDER` can be used to specify a
      path to a folder for storing the database files at a different location.
    - The `adbinst.exe`, `aadma.exe` and `areena.exe` tools can be started with
      a `-Portable` parameter, which will make them use / look for the database
      files in relative folder `sqlitedbs/` instead.
    - SQLite only allows one process / thread to write to the database at a
      time. It is possible to use the Development Toolkit and several Modelling
      Toolkits at the same time, but when one is performing some major updates
      on the database, e.g. importing many models, then the other Toolkits
      using the same database have to wait for that task to allow to interject
      or for it to be finished.
    - Performing many write actions to the database at once or in really quick
      succession, e.g. importing many models, has lower performance than MS SQL
      Server. This is most likely due to constantly acquiring and releasing the
      DB file lock.
    - To improve the performance for importing many models when using SQLite,
      the task now acquires a write lock to the database at the start of the
      import and releases it once the import is finished. This has practically
      two implications, 1: other processes must wait for the import to finish
      before they can write to the database and 2: the size of the "rollback"
      file (WAL file) becomes large enough to hold most of the model data. It
      is truncated after the import to a smaller size (~8MB). In numbers, when
      testing with importing ~550 models of varying sizes the import requires
      ~1 minute and the "rollback" file ~67MB. For comparison without the
      improvement the same import would take ~8 minutes and the "rollback" file
      stays at ~8MB.
    - The "user lock" behavior (for logged in users, locking models etc.) has
      been slightly changed when using SQLite, but should still be similar to
      previous versions of ADOxx.

### Changed
* When providing samples during database creation with `adbinst.exe` via the
  `-samples` parameter, then Attribute Profiles are imported next to the
  default "Attribute profiles" folder as siblings instead of importing them as
  sub-folders into that folder.
    - This change was necessary to allow importing Attribute Profile folders
      as children of the "root" folder. This is for example used by the "ADOxx
      Auto Start" module.



## [1.8.0-a7] - 2023-06-20

### Added
* A "Save" button to the "Edit class hierarchy" dialog in the Development
  Toolkit.
* A "Create copy..." button to the "Library management" dialog in the
  Development Toolkit.
* Added the LEO function `encodeuri ( content [ , allowed ] )` which encodes
  characters using typical URI encoding `%xx`.
* Added the LEO function `tourlquerystring ( amap [ , allowed ] )` which
  transforms the data from a map into the URL query string format, encoding
  characters using typical URI encoding `%xx`.
* Added several commands for library (meta-model) manipulation to the Modelling
  Toolkit that were previously only available in the Development Toolkit.
* Added a new command `"Core" GET_SUPERCLASS_IDS`, which gets all the super
  classes of a class ("recursive").
* Added a new command `"Core" GET_SUBCLASS_IDS`, which gets the direct or all
  ("recursive") sub classes of a class.
* Added a new command `"Core" DELETE_CLASS`, which deletes a class from the
  class hierarchy.
* Added a new command `"Core" CREATE_RELATIONCLASS`, which adds a new relation
  class to the class hierarchy.
* Added a new command `"Core" DELETE_RELATIONCLASS`, which deletes a relation
  class from the class hierarchy.
* Added a new command `"Application" GENERATE_LIBRARY_XML`, which exports a
  library in XML format. It is only available in the Development Toolkit.
* Added a new command `"Application" RELOAD`, which reloads most of the
  library and application configuration.

### Changed
> IMPORTANT: The value returned by `"AdoScript" HTTP_REQUEST` for `header` has
> changed from a string to a map! Check and adapt libraries / modules / models
> when updating from ADOxx 1.5 to this or a newer version!
* In the "AdoScript" MessagePort, replaced the previous winhttp.h based HTTP
  client with the libcurl based one. It is mostly the same, except:
    - The returned `header` value is now a map containing only the headers. The
      status code is instead returned as `statuscode`.
    - The `timeout` works a bit different now due to the differences between
      winhttp.h and curl. The new ones only allow for a "total timeout" and a
      "connection timeout". Old timeout settings are translated as best as
      possible to the new ones.
    - Previously it seemed to be necessary to call the `fromutf8` function
      twice to get readable values from the response (limited by collation,
      charset etc.). Now once is enough.
    - The "proxy" settings have not been tested yet.
* Renamed several of the commands for library (meta-model) manipulation to be
  consistent with other namings (`LOAD_MODEL`, `SAVE_LIBRARY` etc.). For
  example `LOAD_LIB` and `DISCARD_LIB` to `LOAD_LIBRARY` and `DISCARD_LIBRARY`.
  The old naming of the commands is still available, but should be avoided.
* The `GET_SUPERCLASS_ID` command can now also be used even if the "class
  hierarchy management" component is not available.
* The `SET_ATTR_VAL` command now returns an error when trying to change the
  attribute of a model that is not loaded.
* The name for "External coupling" file for the Development Toolkit has been
  changed to `ado_dev_coupling.asc`.
* The command line argument to skip loading the "External coupling" file when
  starting the Development Toolkit has been changed to `-nodevcoupling`.
* The command for events in the Development Toolkit has been changed to
  `ON_DEV_EVENT`.

### Fixed
* Generation of JPEG images from models (issue #57).
* Command `"AdoScript" HTTP_REQUEST` not working with providing a variable or
  expression for the `reqheader` parameter (issue #126).
* Command `"AdoScript" HTTP_REQUEST` failing on Linux and macOS when calling
  an HTTPS URL due to ".crt file not found" (issue #127).



## [1.8.0-a6] - 2023-01-23

### Added
* The `BITMAP` and `BITMAPINFO` commands can now load image files from the
  internet through HTTP/S requests. This is performed when its `fileNameExpr`
  parameter evaluates to something that starts with `http:` or `https:`.

### Changed
* Disabled database collation check, since it caused problems on macOS.



## [1.8.0-a5] - "nightly-build" 2022-12-14

### Added
* Some of the 3rd party license files to `doc/licenses`.
* The `tools/zip` folder with the 7za contents, because it is used.
* A "data version number" that differs from the "product version number". It is
  currently set to "4.0".
  - Also added the `dataver` return variable of type string for the
    `CC "Application" GET_VERSION` command call.
* Extended the platform version number by a `dev` string that can be added to
  the end of the version, to indicate an "in development" version, e.g.
  `a5.dev` in `1.8.0.4453-a5.dev`.
* The option for the "help" function to open a URL instead of the normal `.chm`
  help.

### Changed
* Updated and re-built various 3rd party libraries (libjpeg, libpng, xerces and
  zlib).
* Renamed some of the new MessagePort commands for the HTTP type attribute:
    - `CC "Core" GET_ALL_REQUEST_NAMES` -> `GET_ALL_HTTP_REQUEST_IDS`
    - `CC "Core" GET_REQUESTS_COUNT` -> merged into `GET_ALL_HTTP_REQUEST_IDS`
    - `CC "Core" GET_REQUEST_VAL` -> `GET_HTTP_REQUEST_VAL`
    - `CC "Core" ADD_NEW_REQUEST` -> `ADD_HTTP_REQUEST`
    - `CC "Core" DELETE_REQUEST` -> `DELETE_HTTP_REQUEST`
    - `CC "Core" REPLACE_REQUEST` -> `SET_HTTP_REQUEST`, can also add
    - `CC "Core" RUN_ALL_REQUESTS` -> `RUN_HTTP_REQUESTS`
    - `CC "Core" RUN_SELECTED_REQUESTS` -> merged into `RUN_HTTP_REQUESTS`
* Also reworked some of the new MessagePort commands for the HTTP type
  attribute, e.g. different inputs and outputs etc. For details see
  "The document of AdoScript for the attribute HTTP.pdf".
* Changed some internal data types for storing HTTP type attributes to more
  meaningful ones, specifically from string to integer where it fits (issue
  #96).
* Changed where HTTP type attributes are stored in the database. This should at
  least mitigate some of the problems from issue #80. The current limit should
  be slightly above 1000000 characters for the entire attribute. Saving is
  prevented and an error is presented when the attribute value would exceed the
  known limit, both when manually editing through the GUI or through AdoScript
  (careful with unsupervised AdoScripts). Note that long attribute values make
  the Notebook very slow and should be avoided.

### Removed
* Removed `asmc` component, since it was apparently a bug-fix for MSVC 6 SP5
  that was supposedly fixed in MSVC 6 SP6. If an error due to some _EH_prolog2
  assembler label (I assume in the sense of prologue, not the programming
  language) is encountered, then restore this again (commit message is
  `removed asmc component`).
* Removed dependency on 3rd party libraries rapidjson and a base64 library.

### Fixed
* Issue #71 where importing an ADL files that has been exported with ADOxx 1.8
  failed. It now uses a separate "data version number".
* Issue #74 by showing a simple message like with `CC "AdoScript" MSGWIN`
  while the HTTP requests are executed through the GUI.
* Issue #77 where using the "Run for the selected requests" button would
  execute the wrong requests. It should now execute the selected requests.
* Issue #93 by changing the return value of the `GET_ALL_HTTP_REQUEST_IDS` and
  the parameter of the `RUN_HTTP_REQUESTS` commands.
* Issue #96 (see above at "Changed").
* Issue #110 where certain HTTP requests would case a crash of the platform.
* Development Toolkit not responding when trying to open the "User list", "User
  group list" and "Export users" tools.



## [1.8.0-a4] - "nightly-build" 2022-09

### Added
* New "HTTP" attribute type that can be used in classes to store and execute
  HTTP requests. Additional commands have been added to the "Core" MessagePort
  to support using the attribute. See "The document of AdoScript for the
  attribute HTTP.pdf" for details.
* New `HTTP_REQUEST_EX` command to the "AdoScript" MessagePort which allows to
  execute HTTP requests with a request body and several other details.
  Practically it is the "Extended HTTP Requests" ADOxx module integrated.
  See "The document of AdoScript HTTP_REQUEST_EX.pdf" for details.
* A custom "development" part to the version string that can be used to provide
  a specific identifier for an "in development" / nightly-build version.
  - Also added the `dev` return variable of type string for the
    `CC "Application" GET_VERSION` command call.

### Changed
* The style of "in development" version numbers from alpha, beta, gamma etc. to
  a1, a2 etc.



## [1.8.0-a3] - unreleased

### Added
* Finally added a changelog.

### Changed
* Made some LEO functions / operators behave "nicer":
    - `VAL` no longer throws an error if a number, time or measure is passed.
    - `STR` no longer throws an error if a string is passed.

### Removed
* Forced change of Admin password when first logging in.



## [1.8.0-a2] - unreleased

### Changed
* Used English as the default language.
* Adapted texts to use ADOxx instead of ADONIS.
* Changed DB user and schema to ADOxx.
* Reworked internal version numbering to follow closer to semantic versioning
  (as used in this changelog) and removing the "UL" and "HF" (whatever those
  were).

### Removed
* Removed the German help files.
* Removed all languages besides English from various files.
    - Removal was necessary, because the files seemed to use ANSI encoding with
      different code pages in the same file (e.g. either possible to show
      German properly or French properly, but not both). The removal of
      non-English languages should make most of the files now work correctly
      for UTF-8.



## [1.8.0-a1] - unreleased
This is the first version that builds on newer systems (Windows 8+).
